// Grab_Checklist1 = client.getTable('Grab_Checklist1');
// Grab_Checklist2 = client.getTable('Grab_Checklist2');
// Grab_Checklist3 = client.getTable('Grab_Checklist3');

var addChecklistBtn1 = new sap.m.Button({text:oBundle.getText("Create_New_Inspection_Form"),type:sap.m.ButtonType.Emphasized,
                                    icon: sap.ui.core.IconPool.getIconURI("add"),
                                    press:function(){
                                        if(hvi_login_type == "1"  || (hvi_login_type == "2" && hvi_account_access_value.indexOf('create_inspection_form') != -1)){
                                            addChecklist1();
                                        }else{
                                            sap.m.MessageToast.show("Create Access not provided.");
                                        }
                                    } 
                                }).addStyleClass("sapUiSmallMargin"); 

var howToChecklistBtn = new sap.m.Button({text:oBundle.getText("Learn"),type:sap.m.ButtonType.Accept,
                                    icon: sap.ui.core.IconPool.getIconURI("sys-help"),press:howToAddChecklist });
var defaultChecklistBtn = new sap.m.Button({text:oBundle.getText("Default_Inspection_Form"),type:sap.m.ButtonType.Emphasized,
                                    icon: sap.ui.core.IconPool.getIconURI("survey"),press:function(){
                                        oLayoutCheckList.to("default_checklist");
                                    }});
var treeTableTitle = new sap.m.Label({text: ""});

 var checklistBack4 = new sap.m.Button({
    type: "Accept",
    width: "100px",
    text:oBundle.getText("Back"),
    icon: "sap-icon://navigation-left-arrow",
    press: function (e) {
        oLayoutCheckList.back();
    }
});

 var group_id = "";
 var subGroup_id = "";


function displayMenuChecklist2(event,obj){

    var mid = obj['id'];
    var subgroup_name = obj['name'];

    var oMenu = new sap.m.Menu({
        items: [new sap.m.MenuItem({icon: "sap-icon://edit",text: oBundle.getText("Update"),key: "1"})],
        itemSelected: function (oEvent) {
            var oItem = oEvent.getParameter("item").getKey();
            if (oItem == "1") {
                updateSection(mid,subgroup_name);
            } else if (oItem == "2") {
                if(hvi_login_type == "1"  || (hvi_login_type == "2" && hvi_account_access_value.indexOf('delete_inspection_form') != -1)){
                    deleteConfirmChecklist("2",mid)
                }else{
                    sap.m.MessageToast.show("Delete Access not provided.");
                }
            }
        }
    });
    getDeleteMenu(oMenu,"2");
    oMenu.openBy(event.getSource());
}

function displayMenuChecklist3(event,obj){
        var mid = obj['id'];
        var checklist = obj['name'];

    var oMenu = new sap.m.Menu({
        items: [new sap.m.MenuItem({icon: "sap-icon://edit",text: oBundle.getText("Update"),key: "1"})],
        itemSelected: function (oEvent) {
            var oItem = oEvent.getParameter("item").getKey();
            if (oItem == "1") {
               updateChecklistTree(obj);
            } else if (oItem == "2") {
                if(hvi_login_type == "1"  || (hvi_login_type == "2" && hvi_account_access_value.indexOf('delete_inspection_form') != -1)){
                    deleteConfirmChecklist("3",mid)
                }else{
                    sap.m.MessageToast.show("Delete Access not provided.");
                }
            }
        }
    });
    getDeleteMenu(oMenu,"2");
   oMenu.openBy(event.getSource());
}
      
var oTableDefaultChecklist = new sap.m.Table({
        growing: false,
        noDataText:oBundle.getText("No_Data"),
        growingTriggerText:oBundle.getText("More"),
        sticky:[sap.m.Sticky.ColumnHeaders,sap.m.Sticky.HeaderToolbar,sap.m.Sticky.InfoToolbar],
        growingThreshold: 12,
        growingScrollToLoad : false,
        columns: [
            new sap.m.Column({width:"100px",header: new sap.m.Label({text: oBundle.getText("SN"),design: sap.m.LabelDesign.Bold}), width:"60px"}),
            new sap.m.Column({header: new sap.m.Label({ text: oBundle.getText("Inspection"), design: sap.m.LabelDesign.Bold}),
            minScreenWidth : "Desktop",popinDisplay : "WithoutHeader",demandPopin : true }),
            new sap.m.Column({header: new sap.m.Label({text: oBundle.getText("Display"),design: sap.m.LabelDesign.Bold}),width: "120px"}),
            new sap.m.Column({header: new sap.m.Label({text: oBundle.getText("Copy"),design: sap.m.LabelDesign.Bold}),width: "120px"})
        ]
    }).addStyleClass('withGrid');

var templateChecklistDefault = new sap.m.ColumnListItem({
          cells: [
                new sap.m.Label({ text: "{SerialNo}" }),
                new sap.m.Label({ text: "{group_name}" }),
                new sap.m.Switch({
                    state: false,
                    type: sap.m.SwitchType.AcceptReject,
                    name: {
                        path: "id",
                        formatter: function (value) {
                            if (value != null) {
                                if (checklistIDArray.indexOf(value) > -1) {
                                    this.setState(true);
                                } else {
                                    this.setState(false);
                                }
                            }
                        }
                    },
                    change: function (e) {
                        var model = this.getModel();
                        var path = e.getSource().getBindingContext().getPath();
                        var obj = model.getProperty(path);
                        var mid = obj['id'];
                        if (this.getState()) {
                            checklistIDArray.push(mid);
                        } else {
                            var index = checklistIDArray.indexOf(mid);
                            if (index > -1) {
                                checklistIDArray.splice(index, 1);
                            }
                        }

                        saveDefaultChecklistDisplay();
                    }
                }),
                new sap.m.Button({text:oBundle.getText("Copy"),
                    press: function (e) {
                        var model = this.getModel();
                        var path = e.getSource().getBindingContext().getPath();
                        var obj = model.getProperty(path);
                        var mid = obj['id'];
                        var group_name = obj['group_name'];
                        var source_email = obj['user_email'];
                        
                        if(subscription_status != "Inactive" && subscription_status != "Cancelled"){
                            copyChecklist(source_email,group_name,mid);
                        }else{
                            sap.m.MessageBox.error(oBundle.getText("This feature is available for subscribe user  - Please upgrade your plan to use this feature.")
                            ,{title: oBundle.getText("Error")});
                        }
                    }
                }),
             ]
      });



// function copyChecklist(source_email,group_name,id) {


//    /* alert(source_email);
//     alert(emailUser);
//     alert(group_name);
//     alert(id);*/
//     busyDialog.open();
//     $.ajax({
//         type: "POST",
//         url: "https://prod-162.westeurope.logic.azure.com:443/workflows/920237f5cab44b9cad06288c06d2e352/triggers/manual/paths/invoke?api-version=2016-06-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=zbeSa1_Zc5lhhzOgM84NLXklQ7ZZwo2FJUPO8Uv9RVY",
//         contentType: 'application/json',
//         dataType: 'json',
//         data: JSON.stringify({
//                 "source_email": source_email,
//                 "user_email": emailUser,
//                 "group_name": group_name,
//                 "id": id
//         }),
//         success: function (data) {
//            // alert( JSON.stringify(data));
//             busyDialog.close();
//             sap.m.MessageBox.success(oBundle.getText("Checklist_Copied")
//             ,{title: oBundle.getText("Success")});
//             funGetChecklist();
//          }
//     });

// }


var VSDChecklistDefault = new sap.m.ViewSettingsDialog({
          confirm: function (oEvent) {
              var p = oEvent.getParameters(),
                   oSorter = null;
              if (p.sortItem) {
                  oSorter = p.sortItem.getCustomData()[0].getValue();
                  if (oSorter) {
                      oSorter.bDescending = p.sortDescending;
                      oTableDefaultChecklist.getBinding("items").sort(oSorter);
                  }
              }
          }
      });

  VSDChecklistDefault.addSortItem(new sap.m.ViewSettingsItem({
          text: oBundle.getText("Inspection"),selected: true,
          customData: new sap.ui.core.CustomData({
              value: new sap.ui.model.Sorter("group_name", false)
          })
      }));
     
 oTableDefaultChecklist.setInfoToolbar(new sap.m.Toolbar({
        content: [
        checklistBack4,
        // new sap.m.Label({text: oBundle.getText("Default_Inspection_Form") +" ( New feature -  Copy default form to your account )"}),
        new sap.m.Text({text: oBundle.getText("Default_Inspection_Form") + " " + "( "+ oBundle.getText("New_feature_Copy_default_form_to_your_account")+ " )"}),
        new sap.m.ToolbarSpacer(),
        new sap.m.SearchField({
            placeholder: oBundle.getText("Search"),
            width: "300px",
            liveChange: function (event) {
                var oBinding = oTableDefaultChecklist.getBinding("items");
                var searchStr = this.getValue();
                if (oBinding) {
                    var oFilters = [new sap.ui.model.Filter("group_name", sap.ui.model.FilterOperator.Contains, searchStr)];
                    var filterObj = new sap.ui.model.Filter(oFilters, false);
                    oBinding.filter(filterObj);
                } else {
                    oBinding.filter([]);
                }
            }
        }),
        new sap.m.Button({text:oBundle.getText("sorting"),icon: "sap-icon://sort",type: "Accept",
            press: function () {
                VSDChecklistDefault.open();
            }
        })
    ]
    }));


    
var oBusyDialogChecklist = new sap.m.BusyDialog({text: oBundle.getText("Saving")});

var checklistIDArray = [];

function saveDefaultChecklistDisplay(){
    
   oBusyDialogChecklist.open();
   var uniqueNames = getUnique(checklistIDArray);

    var chkID = "";
    for (var i = 0; i < uniqueNames.length; i++) {
        chkID = chkID + uniqueNames[i]+"^";
    }

    chkID = chkID.slice(0, -1);

    if(chkID==""){chkID="2019"}

    loginTable.update({ id: emailUser, checklist: chkID }).done(function () {
        oBusyDialogChecklist.close();
        //checkLoginBlock();
    }); 

}

function getUnique(array){
    var uniqueArray = [];
    for(i=0; i < array.length; i++){
        if(uniqueArray.indexOf(array[i]) === -1) {
            uniqueArray.push(array[i]);
        }
    }
    return uniqueArray;
}
                
var oLayoutCheckList = new sap.m.App({height:"100%",initialPage:"checklist1"});

var oListFormTitle = new sap.m.List({
    // headerText: oBundle.getText("Custom_Inspection_Forms"),
    // footerText: oBundle.getText("form_bottom"),
     growing:true,growingThreshold:25,
     inset : true, //mode: "Delete",
     'delete': function (oEvent) {
         var mlist = oEvent.getParameter("listItem");
         var model = this.getModel();
         var path = mlist.getBindingContext().getPath();
         var obj = model.getProperty(path);
         if(hvi_login_type == "1"  || (hvi_login_type == "2" && hvi_account_access_value.indexOf('delete_inspection_form') != -1)){
            deleteConfirmChecklist("1", obj['id'],obj['group_name']);  
        }else{
            sap.m.MessageToast.show("Delete Access not provided.");
        }
     }});


if(hvi_login_type=="1" ||(hvi_login_type == "2" && hvi_team_role == "4")){
    oListFormTitle.setMode("Delete");
}

var oItemBindingForm = new sap.m.StandardListItem({
         title: "{group_name}",
         description: {
             path: "description",
             formatter: function (description) {
                 if (description != null) {
                     return description;
                 } else {
                     return "Description";
                 }
             }
         },
         type: "DetailAndActive",
        //  info:  {
        //      path: "id",
        //      formatter: function (mid) {
        //          if (mid != null) {
        //              var getItemAreay = jsonArrayHviChecklist3.filter(function (obj, index) {
        //                  return (obj.group_id === mid);
        //              });
        //              return oBundle.getText("Inspection_Item")+" - "+getItemAreay.length;
        //          }
        //      }
        //  },
         icon: "sap-icon://navigation-right-arrow",
         /*
         counter: {
             path: "id",
             formatter: function (mid) {
                 if (mid != null) {
                     var getItemAreay = jsonArrayHviChecklist3.filter(function (obj, index) {
                         return (obj.group_id === mid);
                     });
                     return getItemAreay.length;
                 }
             }
         },
         */
        //  infoState: "Success",
        info: {
            path: "active_status",
            formatter: function (status) {
                if (status === "1") {
                    return "✅ Active";
                } else if (status === "0") {
                    return "❌ Inactive";
                } else {
                    return "";
                }
            }
        },      
         press: function (e) {

             var model = this.getModel();
             var path = e.getSource().getBindingContext().getPath();
             var obj = model.getProperty(path);
             group_id = obj['id'];
             var group_name = obj['group_name'];
             treeTableTitle.setText(group_name);
             oLayoutCheckList.to("tree_checklist");
             funGetTreeChecklist("form_page");

         },
         detailPress: function (e) {
            var model = this.getModel();
            var path = e.getSource().getBindingContext().getPath();
            var obj = model.getProperty(path);
            if(hvi_login_type == "1"  || (hvi_login_type == "2" && hvi_account_access_value.indexOf('modify_inspection_form') != -1)){
                editChecklist1(obj['id'], obj['group_name'], obj['description'],obj['active_status']);
            }else{
                sap.m.MessageToast.show("Modify Access not provided.");
            }
         }
     }); 
     
var FormSearchField = new sap.m.SearchField({
        placeholder: oBundle.getText("Search"),
        width: "300px",
        selectOnFocus: false,
        layoutData: new sap.ui.layout.GridData({span: "L4 M6 S12"}),
        search: function (event) {
            if (event.getParameter("clearButtonPressed")) {
                historySearch.setValue("");
            }
        },
        liveChange: function (event) {

            var oBinding = oListFormTitle.getBinding("items");
            var searchStr = this.getValue();
            if (oBinding) {
                var oFilters = [ new sap.ui.model.Filter("group_name", sap.ui.model.FilterOperator.Contains, searchStr),
                                 new sap.ui.model.Filter("inspection_date", sap.ui.model.FilterOperator.Contains, searchStr)
                               ];
                var filterObj = new sap.ui.model.Filter(oFilters, false);
                oBinding.filter(filterObj);
            } else {
                oBinding.filter([]);
            }
        }

    });

 var formToolbar = new sap.m.OverflowToolbar({
        width: 'auto',
        design:"Transparent",
        content : [
            addChecklistBtn1,
            // new sap.m.Button({text:oBundle.getText("Copy_from_Library"),type:sap.m.ButtonType.Emphasized,
            //                 icon: sap.ui.core.IconPool.getIconURI("copy"),press:function(){
            //                     oLayoutCheckList.to("default_checklist");
            //                 }}),
                new sap.m.ToolbarSpacer(),
                // defaultChecklistBtn,
               // howToChecklistBtn
        ]
    });//.addStyleClass("sapUiTinyMargin");

 var checklistPage1 = new sap.m.Page("checklist1", {
                title:oBundle.getText("Inspection_Form"),
               // titleAlignment:sap.m.TitleAlignment.Start,
               // backgroundDesign:sap.m.PageBackgroundDesign.Solid,
                showHeader:true,
                enableScrolling:true,
                headerContent: [ FormSearchField ],
                
                content : [formToolbar,oListFormTitle] //oTableChecklist1
            }); 
 var checklistPage4 = new sap.m.Page("default_checklist", {
            title:oBundle.getText("DEFAULT_CHECKLIST_DISPLAY"),
            showHeader:false,
            enableScrolling:true,
             footer:new sap.m.OverflowToolbar({
                    width: 'auto',
		            content : [
                        new sap.m.ToolbarSpacer(),
		            ]
	            }),
            content : [oTableDefaultChecklist]
        }); 
           

 function howToAddChecklist(){
     
    var oImageChecklist1 = new sap.ui.commons.Image({width:"100%"});
    oImageChecklist1.setSrc("Images/checklist1.png");

    var oDialogChecklist1 = new sap.ui.commons.Dialog({modal : true,width:"50%"});
    oDialogChecklist1.setTitle(oBundle.getText("How_to_Create_New_Inspection_Form"));
	oDialogChecklist1.addContent(oImageChecklist1);
	oDialogChecklist1.open();
 }

 var customInspectionFormJSON = [];

  function funGetChecklist() {

      oListFormTitle.setBusy(true);
      Grab_Checklist1.where({ master_email: emailUser }).includeTotalCount().orderByDescending("createdAt").take(500).read().done(function (results) {
        
//           for (var i = 0; i < results.length; i++) {
//               results[i]['SerialNo'] = parseInt(i + 1);
//           }

//           var oModelChecklist1 = new sap.ui.model.json.JSONModel();
//           oModelChecklist1.setData({ modelData: results });
//           customInspectionFormJSON = results;

//         //   thirdLayerChecklist(oModelChecklist1);
//           getDefaultCheckList();
//           contentIDtile5.setValue(results.totalCount);
//       });
//   }

          for (var i = 0; i < results.length; i++) {
              results[i]['SerialNo'] = parseInt(i + 1);
          }

          var oModelChecklist1 = new sap.ui.model.json.JSONModel();
          oModelChecklist1.setData({ modelData: results });
          customInspectionFormJSON = results;
          inspectionFormJSON  = results;

          oListFormTitle.setModel(oModelChecklist1);
          oListFormTitle.bindAggregation("items", "/modelData", oItemBindingForm);
          oListFormTitle.setBusy(false);
        //   thirdLayerChecklist(oModelChecklist1);
        //   getDefaultCheckList();
        //   contentIDtile5.setValue(results.totalCount);
      });
  }

  var inspectionFormJSON = [];
  function getDefaultCheckList(){

      Grab_Checklist1.where({ user_email: '2341990', language: languageCode }).take(200).
        read().done(function (results) {

            results.sort(function (a, b) {
                a = a.group_name.toLowerCase();
                b = b.group_name.toLowerCase();
                return a < b ? -1 : a > b ? 1 : 0;
            });

            for (var i = 0; i < results.length; i++) {
                results[i]['SerialNo'] = parseInt(i + 1);
            }

            var oModel1 = new sap.ui.model.json.JSONModel();
            oModel1.setData({ modelData: results });

            oTableDefaultChecklist.setModel(oModel1);
            oTableDefaultChecklist.bindItems({
                path: "/modelData",
                template: templateChecklistDefault
            });

            if (checklistIDArray.length >0 ) {

                var defaultActiveChecklist = results.filter(function (obj, index) {
                    return (checklistIDArray.indexOf(obj.id) > -1);
                });
                var combineJSON = defaultActiveChecklist.concat(customInspectionFormJSON);
                inspectionFormJSON = combineJSON;
            }else{
                var combineJSON = results.concat(customInspectionFormJSON);
                inspectionFormJSON = combineJSON;
            }
        });
  }

 var skipValueHviChecklist3 = 0;
 var jsonArrayHviChecklist3 = [];
 
  function thirdLayerChecklist(oModelChecklist1){

      Grab_Checklist3.where({ master_email: emailUser }).skip(skipValueHviChecklist3).take(1000).orderByDescending("createdAt").read().done(function (results) {

          jsonArrayHviChecklist3 = jsonArrayHviChecklist3.concat(results);

          if (results.length < 1000) {

              // oGridList.setModel(oModelChecklist1);
              oListFormTitle.setBusy(false);
              //alert(jsonArrayHviChecklist3.length);

              for (var i = 0; i < jsonArrayHviChecklist3.length; i++) {
                  jsonArrayHviChecklist3[i]['SerialNo'] = parseInt(i + 1);
              }

              oListFormTitle.setModel(oModelChecklist1);
              oListFormTitle.bindAggregation("items", "/modelData", oItemBindingForm);

              skipValueHviChecklist3 = 0;
              jsonArrayHviChecklist3 = [];

          } else {
              skipValueHviChecklist3 = skipValueHviChecklist3 + 1000;
              thirdLayerChecklist(oModelChecklist1);
          }

      });

  }
 
  function addChecklist1(){
      
    var textField = new sap.m.Input({value: "", width: "100%" });
    var descriptionField = new sap.m.TextArea({width:"100%",height:"60px",rows : 3, 
            wrapping : sap.ui.core.Wrapping.on}).addStyleClass("field");

    var oLabel1 = new sap.m.Label({ text: oBundle.getText("Form_Title")});
    var oLabel2 = new sap.m.Label({ text: oBundle.getText("Form_Description")});

    var oDialogChecklist1 = new sap.m.Dialog({
        modal: true,
        title: oBundle.getText("Form_Title"),
        state: sap.ui.core.ValueState.Success,
        content: [oLabel1,textField,oLabel2,descriptionField],
        buttons: [
                    new sap.m.Button({
                        text: oBundle.getText("Save"),
                        icon: "sap-icon://save",
                        press: function () {
                            var value = textField.getValue();
                            var description = descriptionField.getValue();
                            if (validation(value, oBundle.getText("Form_Title"))) { return; }

                            Grab_Checklist1.insert({ master_email: emailUser, group_name: value, description:description,active_status:'1' }).done(function () {
                                funGetChecklist();
                                addHistoryTableData(value,"Insert","Checklist1");
                            }, failure);
                            oDialogChecklist1.close();
                        }
                    }),
					new sap.m.Button({
					    text: oBundle.getText("Cancel"),
					    icon: "sap-icon://decline",
					    press: function () {
					        oDialogChecklist1.close();
					    }
					})
				]
    }).open();
    
  }

  function editChecklist1(mid,group_name,descriptionValue,status){
      
    var textField = new sap.m.Input({value: ""+group_name, width: "100%" });
    
    if(descriptionValue==null){
        descriptionValue = "";
    }

    var descriptionField = new sap.m.TextArea({value:""+descriptionValue,width:"100%", height:"60px",rows : 3, 
            wrapping : sap.ui.core.Wrapping.on
	        }).addStyleClass("field");

    var oCBChecklist = new sap.m.ComboBox({
        width:'100%',
        selectedKey:"0",
        // value:oBundle.getText("Active"),
        items:[    
            new sap.ui.core.ListItem({key:"1",text:oBundle.getText("Active")}),
            new sap.ui.core.ListItem({key:"0",text:oBundle.getText("Inactive")}),
        ]
    }).addEventDelegate({onAfterRendering: function(e) {oCBChecklist.$().find("input").attr("readonly", true);}});
        

    oCBChecklist.setSelectedKey(status)
    // if(status == 'Active'){
    //     console.log('a')
    //     oCBChecklist.setValue('Active');
    // }else{
    //     console.log('b')
    //     oCBChecklist.setSelectedKey('0')
    //     oCBChecklist.setValue('Inactive');
    // }
    var oLabel1 = new sap.m.Label({ text: oBundle.getText("Title")});
    var oLabel2 = new sap.m.Label({ text: oBundle.getText("Description")});
    var oLabel3 = new sap.m.Label({ text: oBundle.getText("Status")});

     var oDialog = new sap.m.Dialog({
        modal : true,
        title: oBundle.getText("Update_Inspection_Title"),
        state: sap.ui.core.ValueState.Success,
        content: [oLabel1,textField,oLabel2,descriptionField,oLabel3,oCBChecklist],
        buttons: [
                    new sap.m.Button({
					    text: oBundle.getText("Update"),
					    icon: "sap-icon://edit",
					    press: function () {
                            var value = textField.getValue();
                            var description = descriptionField.getValue();
                            var newstatus = oCBChecklist.getSelectedKey()+"";

                            if (validation(value, oBundle.getText("Form_Title"))) { return; }
                            if (validation(newstatus, oBundle.getText("Status"))) { return; }

                           Grab_Checklist1.update({id:mid, master_email: emailUser, group_name: value,description:description,active_status:newstatus }).done(function () {
                            funGetChecklist();
                            addHistoryTableData(value,"Update","Checklist1",
                                {"group_name":group_name,"description":descriptionValue,active_status:status},
                                {"group_name":value,"description":description,active_status:newstatus});
                            oDialog.close();
                            sap.m.MessageBox.success(oBundle.getText("Done"));
                           },failure);
					    }
					}),
					new sap.m.Button({
					    text: oBundle.getText("Cancel"),
					    icon: "sap-icon://decline",
					    press: function () {
					        oDialog.close();
					    }
					})
				]
    }).open();

  }


  //
  function deleteConfirmChecklist(type,mid,group_name){
   
        sap.m.MessageBox.show(oBundle.getText("Do_you_want_to_delete"),
		sap.m.MessageBox.Icon.ERROR,
		oBundle.getText("Alert"),
		[sap.m.MessageBox.Action.YES, sap.m.MessageBox.Action.NO],
		function (bConfirmed) {
		    if (bConfirmed == "YES") {

		        if (type == "1") {
                    Grab_Checklist1.del({ id: mid }).done(function () {
                        funGetChecklist();
                        addHistoryTableData(mid,"Delete","Checklist1");
                        deleteChecklist(mid,group_name);
                    }, failure);
                } else if (type == "2") {
                    Grab_Checklist2.del({ id: mid }).done(function () {
                        funGetTreeChecklist();
                        addHistoryTableData(mid,"Delete","Checklist2");
                        //sap.m.MessageBox.success(oBundle.getText("Done"));
                    }, failure);
                } else if (type == "3") {
                    Grab_Checklist3.del({ id: mid }).done(function () {
                        funGetTreeChecklist();
                        addHistoryTableData(mid,"Delete","Checklist3");
                        //sap.m.MessageBox.success(oBundle.getText("Done"));
                    }, failure);
                }
                
		    }
		});

  }

  //Oxmaint - Automatically Delete Checklist
  function deleteChecklist(mid,group_name) {

     busyDialog.open();
     $.ajax({
         type: "POST",
         url: "https://prod-202.westeurope.logic.azure.com:443/workflows/1a46aedc67d9449e912876118ce4dfcb/triggers/manual/paths/invoke?api-version=2016-06-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=zjlv9lp2KLRPO8Jc6cXRpMbHFV4ffbt0Z1OhAVBnoS8",
         contentType: 'application/json',
         dataType: 'json',
         data: JSON.stringify({
                 "source_email": emailUser,
                 "form_id": mid,
                 "group_name": group_name
         }),
         success: function (data) {
            // alert( JSON.stringify(data));
            busyDialog.close();
            funGetChecklist();
          }
     });

       
 
 }

 function failure(){
    alert("Operation failed");
}
